/*
 * Decompiled with CFR 0.152.
 */
package com.dodgeman.shw.saveddata.mappers;

import com.dodgeman.shw.saveddata.mappers.CompoundMapper;
import com.dodgeman.shw.saveddata.models.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class PositionMapper
implements CompoundMapper<Position> {
    private static final String DIMENSION_KEY = "dimension";
    private static final String X_KEY = "x";
    private static final String Y_KEY = "y";
    private static final String Z_KEY = "z";
    private static final String RY_KEY = "ry";
    private static final String RX_KEY = "rx";

    public static Position fromPlayer(ServerPlayer player) {
        Vec3 position = player.m_20182_();
        Vec2 rotation = player.m_20155_();
        ResourceKey dimension = player.m_9236_().m_46472_();
        return new Position(dimension.m_135782_().toString(), position.f_82479_, position.f_82480_, position.f_82481_, rotation.f_82471_, rotation.f_82470_);
    }

    @Override
    public Position fromCompoundTag(CompoundTag tag) {
        String dimension = tag.m_128461_(DIMENSION_KEY);
        double x = tag.m_128459_(X_KEY);
        double y = tag.m_128459_(Y_KEY);
        double z = tag.m_128459_(Z_KEY);
        float ry = tag.m_128457_(RY_KEY);
        float rx = tag.m_128457_(RX_KEY);
        return new Position(dimension, x, y, z, ry, rx);
    }

    @Override
    public CompoundTag toCompoundTag(Position position) {
        CompoundTag tag = new CompoundTag();
        if (position == null) {
            return tag;
        }
        tag.m_128359_(DIMENSION_KEY, position.dimension());
        tag.m_128347_(X_KEY, position.x());
        tag.m_128347_(Y_KEY, position.y());
        tag.m_128347_(Z_KEY, position.z());
        tag.m_128350_(RY_KEY, position.ry());
        tag.m_128350_(RX_KEY, position.rx());
        return tag;
    }
}

